
CREATE TABLE PIT.VeteranSurvey
(
	DEVICEID VARCHAR2(40) NOT NULL,
        SURVEYID VARCHAR2(100) NOT NULL,
	SURVEYDATE DATE NOT NULL,
	FIRSTNAME VARCHAR2(255) NULL,
	MIDDLENAME VARCHAR2(255) NULL,
	LASTNAME VARCHAR2(255) NULL,
	GENDER CHAR(1) NOT NULL,
	AGE NUMBER NULL,
	CHRONICALLYHOMELESS NUMBER NOT NULL ,
	LOCATIONLATITUDE NUMBER NULL,
	LOCATIONLONGITUDE NUMBER NULL,
	LOCATIONACCURACY NUMBER NULL,
	ADDRESS VARCHAR2(255) NULL,
	CITY VARCHAR2(255) NULL,
	STATE VARCHAR2(2) NULL,
	RECORDCREATEDDATE DATE DEFAULT (sysdate) NOT NULL,
    CONSTRAINT CHECK_GENDER CHECK (GENDER IN ('F', 'M', 'f', 'm')) ENABLE,
    CONSTRAINT CHECK_CHRONICALLYHOMELESS CHECK (CHRONICALLYHOMELESS =1 OR CHRONICALLYHOMELESS =0) ENABLE,
    CONSTRAINT PK_SURVEYID PRIMARY KEY (DEVICEID, SURVEYID)
)


